page_type: reference
description: The TensorFlow Lite Task Library.

<link rel="stylesheet" href="/site-assets/css/style.css">

<!-- DO NOT EDIT! Automatically generated file. -->


<div itemscope itemtype="http://developers.google.com/ReferenceObject">
<meta itemprop="name" content="tflite_support.task" />
<meta itemprop="path" content="Stable" />
</div>

# Module: tflite_support.task

<!-- Insert buttons and diff -->

<table class="tfo-notebook-buttons tfo-api nocontent" align="left">
<td>
  <a target="_blank" href="https://github.com/tensorflow/tflite-support/blob/v0.4.4/tensorflow_lite_support/python/task/__init__.py">
    <img src="https://www.tensorflow.org/images/GitHub-Mark-32px.png" />
    View source on GitHub
  </a>
</td>
</table>



The TensorFlow Lite Task Library.


TensorFlow Lite Task Library contains a set of powerful and easy-to-use
task-specific libraries for app developers to create ML experiences with
TensorFlow Lite. It provides optimized out-of-box model interfaces for popular
machine learning tasks, such as image and text classification. The model
interfaces are specifically designed for each task to achieve the best
performance and usability.

Read more in the [Task Library Guide](
https://tensorflow.org/lite/inference_with_metadata/task_library/overview).

## Modules

[`audio`](../tflite_support/task/audio) module: TensorFlow Lite Task Library Audio APIs.

[`core`](../tflite_support/task/core) module: TensorFlow Lite Task Library's core module.

[`processor`](../tflite_support/task/processor) module: TensorFlow Lite Task Library's processor module.

[`text`](../tflite_support/task/text) module: TensorFlow Lite Task Library Text APIs.

[`vision`](../tflite_support/task/vision) module: TensorFlow Lite Task Library Vision APIs.
