#!/usr/bin/env python3
#
# SPDX-License-Identifier: BSD-2-Clause
#
# Copyright (C) 2019, Raspberry Pi Ltd
#
# ctt_pisp.py - camera tuning tool data for PiSP platforms


json_template = {
    "rpi.black_level": {
        "black_level": 4096
    },
    "rpi.lux": {
        "reference_shutter_speed": 10000,
        "reference_gain": 1,
        "reference_aperture": 1.0
    },
    "rpi.dpc": {
	"strength": 1
    },
    "rpi.noise": {
    },
    "rpi.geq": {
    },
    "rpi.denoise":
    {
        "normal":
        {
            "sdn":
            {
                "deviation": 0.6,
                "strength": 0.95,
                "deviation2": 3.2,
                "deviation_no_tdn": 3.2,
                "strength_no_tdn": 0.95
            },
            "cdn":
            {
                "deviation": 200,
                "strength": 0.3
            },
            "tdn":
            {
                "deviation": 1.0,
                "threshold": 0.05
            }
        },
        "hdr":
        {
            "sdn":
            {
                "deviation": 0.6,
                "strength": 0.95,
                "deviation2": 3.2,
                "deviation_no_tdn": 3.2,
                "strength_no_tdn": 0.95
            },
            "cdn":
            {
                "deviation": 200,
                "strength": 0.3
            },
            "tdn":
            {
                "deviation": 1.3,
                "threshold": 0.1
            }
        },
        "night":
        {
            "sdn":
            {
                "deviation": 0.6,
                "strength": 0.95,
                "deviation2": 3.2,
                "deviation_no_tdn": 3.2,
                "strength_no_tdn": 0.95
            },
            "cdn":
            {
                "deviation": 200,
                "strength": 0.3
            },
            "tdn":
            {
                "deviation": 1.3,
                "threshold": 0.1
            }
        }
    },
    "rpi.awb": {
        "priors": [
            {"lux": 0, "prior": [2000, 1.0, 3000, 0.0, 13000, 0.0]},
            {"lux": 800, "prior": [2000, 0.0, 6000, 2.0, 13000, 2.0]},
            {"lux": 1500, "prior": [2000, 0.0, 4000, 1.0, 6000, 6.0, 6500, 7.0, 7000, 1.0, 13000, 1.0]}
        ],
        "modes": {
            "auto": {"lo": 2500, "hi": 7700},
            "incandescent": {"lo": 2500, "hi": 3000},
            "tungsten": {"lo": 3000, "hi": 3500},
            "fluorescent": {"lo": 4000, "hi": 4700},
            "indoor": {"lo": 3000, "hi": 5000},
            "daylight": {"lo": 5500, "hi": 6500},
            "cloudy": {"lo": 7000, "hi": 8000}
        },
        "bayes": 1
    },
    "rpi.agc":
    {
        "channels":
        [
            {
                "comment": "Channel 0 is normal AGC",
                "metering_modes":
                {
                    "centre-weighted":
                    {
                        "weights":
                        [
                            0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
                            0, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 0,
                            1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
                            1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 3, 4, 3, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 4, 4, 4, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 3, 4, 3, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
                            1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
                            0, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 0,
                            0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0
                        ]
                    },
                    "spot":
                    {
                        "weights":
                        [
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 1, 2, 3, 2, 1, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
                        ]
                    },
                    "matrix":
                    {
                        "weights":
                        [
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
                        ]
                    }
                },
                "exposure_modes":
                {
                    "normal":
                    {
                        "shutter": [ 100, 10000, 30000, 60000, 66666 ],
                        "gain": [ 1.0, 1.5, 2.0, 4.0, 8.0 ]
                    },
                    "short":
                    {
                        "shutter": [ 100, 5000, 10000, 20000, 60000 ],
                        "gain": [ 1.0, 1.5, 2.0, 4.0, 8.0 ]
                    },
                    "long":
                    {
                        "shutter": [ 100, 10000, 30000, 60000, 90000, 120000 ],
                        "gain": [ 1.0, 1.5, 2.0, 4.0, 8.0, 12.0 ]
                    }
                },
                "constraint_modes":
                {
                    "normal": [
                        {
                            "bound": "LOWER",
                            "q_lo": 0.98,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.5,
                                1000, 0.5
                            ]
                        }
                    ],
                    "highlight": [
                        {
                            "bound": "LOWER",
                            "q_lo": 0.98,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.5,
                                1000, 0.5
                            ]
                        },
                        {
                            "bound": "UPPER",
                            "q_lo": 0.98,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.8,
                                1000, 0.8
                            ]
                        },
                    ],
                    "shadows": [
                        {
                            "bound": "LOWER",
                            "q_lo": 0.0,
                            "q_hi": 0.5,
                            "y_target":
                            [
                                0, 0.17,
                                1000, 0.17
                            ]
                        }
                    ]
                },
                "y_target":
                [
                    0, 0.16,
                    1000, 0.165,
                    10000, 0.17
                ]
            },
            {
                "comment": "Channel 1 is the HDR short channel",
                "desaturate": 0,
                "metering_modes":
                {
                    "centre-weighted":
                    {
                        "weights":
                        [
                            0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
                            0, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 0,
                            1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
                            1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 3, 4, 3, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 4, 4, 4, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 3, 4, 3, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
                            1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
                            0, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 0,
                            0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0
                        ]
                    },
                    "spot":
                    {
                        "weights":
                        [
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 1, 2, 3, 2, 1, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
                        ]
                    },
                    "matrix":
                    {
                        "weights":
                        [
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
                        ]
                    }
                },
                "exposure_modes":
                {
                    "normal":
                    {
                        "shutter": [ 100, 20000, 60000 ],
                        "gain": [ 1.0, 1.0, 1.0 ]
                    },
                    "short":
                    {
                        "shutter": [ 100, 20000, 60000 ],
                        "gain": [ 1.0, 1.0, 1.0 ]
                    },
                    "long":
                    {
                        "shutter": [ 100, 20000, 60000 ],
                        "gain": [ 1.0, 1.0, 1.0 ]
                    }
                },
                "constraint_modes":
                {
                    "normal": [
                        {
                            "bound": "LOWER",
                            "q_lo": 0.95,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.5,
                                1000, 0.5
                            ]
                        },
                        {
                            "bound": "UPPER",
                            "q_lo": 0.95,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.7,
                                1000, 0.7
                            ]
                        },
                        {
                            "bound": "LOWER",
                            "q_lo": 0.0,
                            "q_hi": 0.2,
                            "y_target":
                            [
                                0, 0.002,
                                1000, 0.002
                            ]
                        }
                    ],
                    "highlight": [
                        {
                            "bound": "LOWER",
                            "q_lo": 0.95,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.5,
                                1000, 0.5
                            ]
                        },
                        {
                            "bound": "UPPER",
                            "q_lo": 0.95,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.7,
                                1000, 0.7
                            ]
                        },
                        {
                            "bound": "LOWER",
                            "q_lo": 0.0,
                            "q_hi": 0.2,
                            "y_target":
                            [
                                0, 0.002,
                                1000, 0.002
                            ]
                        }
                    ],
                    "shadows": [
                        {
                            "bound": "LOWER",
                            "q_lo": 0.95,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.5,
                                1000, 0.5
                            ]
                        },
                        {
                            "bound": "UPPER",
                            "q_lo": 0.95,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.7,
                                1000, 0.7
                            ]
                        },
                        {
                            "bound": "LOWER",
                            "q_lo": 0.0,
                            "q_hi": 0.2,
                            "y_target":
                            [
                                0, 0.002,
                                1000, 0.002
                            ]
                        }
                    ]
                },
                "y_target":
                [
                    0, 0.16,
                    1000, 0.165,
                    10000, 0.17
                ]
            },
            {
                "comment": "Channel 2 is the HDR long channel",
                "desaturate": 0,
                "metering_modes":
                {
                    "centre-weighted":
                    {
                        "weights":
                        [
                            0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
                            0, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 0,
                            1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
                            1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 3, 4, 3, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 4, 4, 4, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 3, 4, 3, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
                            1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
                            0, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 0,
                            0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0
                        ]
                    },
                    "spot":
                    {
                        "weights":
                        [
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 1, 2, 3, 2, 1, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
                        ]
                    },
                    "matrix":
                    {
                        "weights":
                        [
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
                        ]
                    }
                },
                "exposure_modes":
                {
                    "normal":
                    {
                        "shutter": [ 100, 20000, 30000, 60000 ],
                        "gain": [ 1.0, 2.0, 4.0, 8.0 ]
                    },
                    "short":
                    {
                        "shutter": [ 100, 20000, 30000, 60000 ],
                        "gain": [ 1.0, 2.0, 4.0, 8.0 ]
                    },
                    "long":
                    {
                        "shutter": [ 100, 20000, 30000, 60000 ],
                        "gain": [ 1.0, 2.0, 4.0, 8.0 ]
                    }
                },
                "constraint_modes":
                {
                    "normal": [
                    ],
                    "highlight": [
                    ],
                    "shadows": [
                    ]
                },
                "channel_constraints":
                [
                    {
                        "bound": "UPPER",
                        "channel": 4,
                        "factor": 8
                    },
                    {
                        "bound": "LOWER",
                        "channel": 4,
                        "factor": 2
                    }
                ],
                "y_target":
                [
                    0, 0.16,
                    1000, 0.165,
                    10000, 0.17
                ]
            },
            {
                "comment": "Channel 3 is the night mode channel",
                "base_ev": 0.33,
                "metering_modes":
                {
                    "centre-weighted":
                    {
                        "weights":
                        [
                            0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
                            0, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 0,
                            1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
                            1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 3, 4, 3, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 4, 4, 4, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 3, 3, 3, 4, 3, 3, 3, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 3, 3, 3, 3, 3, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 3, 3, 3, 2, 2, 2, 2, 1, 1,
                            1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1,
                            1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1,
                            0, 1, 1, 1, 1, 1, 2, 2, 2, 1, 1, 1, 1, 1, 0,
                            0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0
                        ]
                    },
                    "spot":
                    {
                        "weights":
                        [
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 1, 2, 3, 2, 1, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 1, 2, 1, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
                        ]
                    },
                    "matrix":
                    {
                        "weights":
                        [
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                            1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
                        ]
                    }
                },
                "exposure_modes":
                {
                    "normal":
                    {
                        "shutter": [ 100, 20000, 66666 ],
                        "gain": [ 1.0, 2.0, 4.0 ]
                    },
                    "short":
                    {
                        "shutter": [ 100, 20000, 33333 ],
                        "gain": [ 1.0, 2.0, 4.0 ]
                    },
                    "long":
                    {
                        "shutter": [ 100, 20000, 66666, 120000 ],
                        "gain": [ 1.0, 2.0, 4.0, 4.0 ]
                    }
                },
                "constraint_modes":
                {
                    "normal": [
                        {
                            "bound": "LOWER",
                            "q_lo": 0.98,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.5,
                                1000, 0.5
                            ]
                        }
                    ],
                    "highlight": [
                        {
                            "bound": "LOWER",
                            "q_lo": 0.98,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.5,
                                1000, 0.5
                            ]
                        },
                        {
                            "bound": "UPPER",
                            "q_lo": 0.98,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.8,
                                1000, 0.8
                            ]
                        }
                    ],
                    "shadows": [
                        {
                            "bound": "LOWER",
                            "q_lo": 0.98,
                            "q_hi": 1.0,
                            "y_target":
                            [
                                0, 0.5,
                                1000, 0.5
                            ]
                        }
                    ]
                },
                "y_target":
                [
                    0, 0.16,
                    1000, 0.16,
                    10000, 0.17
                ]
            }
        ]
    },
    "rpi.alsc": {
        'omega': 1.3,
        'n_iter': 100,
        'luminance_strength': 0.8,
    },
    "rpi.contrast": {
        "ce_enable": 1,
        "gamma_curve": [
            0, 0,
            512, 2518,
            1024, 5033,
            1536, 7175,
            2048, 9309,
            2560, 10814,
            3072, 12312,
            3584, 13773,
            4096, 15225,
            4608, 16566,
            5120, 17899,
            5632, 19221,
            6144, 20534,
            6656, 21684,
            7168, 22826,
            7680, 24024,
            8192, 25212,
            9216, 27251,
            10240, 29167,
            11264, 30947,
            12288, 32696,
            13312, 34309,
            14336, 35849,
            15360, 37194,
            16384, 38445,
            17408, 39598,
            18432, 40732,
            19456, 41717,
            20480, 42687,
            22528, 44343,
            24576, 45871,
            26624, 47222,
            28672, 48441,
            30720, 49460,
            32768, 50470,
            34816, 51476,
            36864, 52480,
            38912, 53382,
            40960, 54294,
            43008, 55155,
            45056, 56035,
            47104, 56920,
            49152, 57824,
            51200, 58737,
            53248, 59666,
            55296, 60604,
            57344, 61558,
            59392, 62529,
            61440, 63516,
            63488, 64519,
            65535, 65535
        ]
    },
    "rpi.ccm": {
    },
    "rpi.cac": {
    },
    "rpi.sharpen": {
	"threshold": 0.75,
	"limit": 0.5,
	"strength": 1.0
    },
    "rpi.hdr":
    {
        "Off":
        {
            "cadence": [ 0 ]
        },
        "MultiExposureUnmerged":
        {
            "cadence": [ 1, 2 ],
            "channel_map": { "short": 1, "long": 2 }
        },
        "SingleExposure":
        {
            "cadence": [1],
            "channel_map": { "short": 1 },
            "spatial_gain": 2.0,
            "tonemap_enable": 1
        },
        "MultiExposure":
        {
            "cadence": [1, 2],
            "channel_map": { "short": 1, "long": 2 },
            "stitch_enable": 1,
            "spatial_gain": 2.0,
            "tonemap_enable": 1
        },
        "Night":
        {
            "cadence": [ 3 ],
            "channel_map": { "night": 3 },
            "tonemap_enable": 1,
            "tonemap":
            [
                0, 0,
                5000, 20000,
                10000, 30000,
                20000, 47000,
                30000, 55000,
                65535, 65535
            ]
        }
    }
}

grid_size = (32, 32)
